<?php
/*
Plugin Name: استعلام سریال
Plugin URI: https://WPFile.ir

Version: 1.1
Author: Parsa
Author URI: https://gigpa.net
*/
if (!defined('ABSPATH')) exit;

class WPFile_GravityForms_Tracking_by_transaction_id
{

    public function __construct()
    {
        add_action('widgets_init', array($this, 'register_widget'));
        add_shortcode('gform_tracker', array($this, 'gform_tracker_shortcode'));
        add_action('wp_ajax_nopriv_gform_tracking_result', array($this, 'gform_tracking_result'));
        add_action('wp_ajax_gform_tracking_result', array($this, 'gform_tracking_result'));

        if (is_admin()) {
            add_action('gform_entry_detail', array($this, 'set_status'), 10, 2);
        }
    }

    public function register_widget()
    {
        register_widget('GF_WPFile_Tracker');
    }

    public function set_status($form, $entry)
    {
        if (empty($entry["transaction_id"]))
            return;

        if (rgpost("new_status_submit")) {

            global $current_user;
            $user_id = 0;
            $user_name = __('مهمان', 'GF_TR');
            if ($current_user && $user_data = get_userdata($current_user->ID)) {
                $user_id = $current_user->ID;
                $user_name = $user_data->display_name;
            }

            if (rgpost("new_status") != gform_get_meta($entry["id"], "hannanstd_entry_status"))
                RGFormsModel::add_note($entry["id"], $user_id, $user_name, sprintf(__('وضعیت جدیدی برای این پیام ثبت شد : %s', 'GF_TR'), rgpost("new_status")));

            gform_update_meta($entry["id"], "hannanstd_entry_status", rgpost("new_status"));
            gform_update_meta($entry["id"], "hannanstd_all_field", rgpost("all_field"));
            gform_update_meta($entry["id"], "hannanstd_status_position", rgpost("status_position"));
            gform_update_meta($entry["id"], "hannanstd_form_id", $form['id']);
        }
        ?>
        <script type="text/javascript">
            var GFTR = jQuery.noConflict();
            GFTR(document).ready(function () {
                <?php if( gform_get_meta($entry["id"], "hannanstd_all_field") != 'true' ) { ?>
                GFTR("#status_position").hide();
                <?php  } ?>
                GFTR("#new_status_all_field").change(function () {
                    if (GFTR('#new_status_all_field:checked').val())
                        GFTR("#status_position").fadeIn();
                    else
                        GFTR("#status_position").fadeOut();
                });
            });
        </script>
        
<div class="postbox">
            <h3>
                <label
                    for="name"><?php echo sprintf(__('تایید استعلام مدرک %s', 'GF_TR'), $entry["transaction_id"]) ?></label>            </h3>
                    
            <div class="inside">
                <table cellspacing="0" class="widefat fixed entry-detail-statuses">
                    <tbody class="list:comment" id="the-comment-list">
                    <tr>
                        <td class="lastrow" style="padding:10px;" colspan="3">

                            <textarea style="width:100%; height:100px; margin-bottom:4px;"
                                      name="new_status"><?php echo gform_get_meta($entry["id"], "hannanstd_entry_status") ?></textarea>

                            <input id="new_status_all_field" type="checkbox" value="true"
                                   name="all_field" <?php echo gform_get_meta($entry["id"], "hannanstd_all_field") == 'true' ? 'checked="checked"' : '' ?> />
                            <label
                                for="new_status_all_field"><?php _e('نمایش تمام اطلاعات در فرم استعلام', 'GF_TR') ?></label>
                            <select name="status_position" id="status_position">
                                <option
                                    value="top" <?php echo gform_get_meta($entry["id"], "hannanstd_status_position") == 'top' ? 'selected="selected"' : '' ?>><?php _e('بالای توضیحات وضعیت ', 'GF_TR') ?></option>
                                <option
                                    value="bottom" <?php echo gform_get_meta($entry["id"], "hannanstd_status_position") == 'bottom' ? 'selected="selected"' : '' ?>><?php _e('پایین توضیحات وضعیت ', 'GF_TR') ?></option>
                            </select>
<?php
echo('<br><input type="submit" name="new_status_submit" style="width:auto;padding-bottom:2px;" class="button button-primary" value="ثبت وضعیت"');
?>
                                   </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <?php
    }

    public function gform_tracker_shortcode()
    {

        $value = __('شماره سریال را وارد نمایید', 'GF_TR');

        $content = '<input id="gform_tr_id" class="gform_tr_id" name="transaction_id" type="text"
			onblur="if (this.value == &quot;&quot;) { this.value = &quot;' . $value . '&quot; }" onfocus="if (this.value == &quot;' . $value . '&quot;) { this.value = &quot;&quot;; }" value="' . $value . '"/>
			<input id="gform_tr_submit" class="button gform_tr_submit" type="submit" value=" ' . __('بررسی', 'GF_TR') . ' " name="trackingsubmit"/>';
        return $this->ajax() . '<div class="tr_result" id="tr_result">' . $content . '</div>';
    }

    public function ajax()
    {
        ?>
        <script type="text/javascript">
            jQuery(document).on("click", "#gform_tr_submit", function () {
                var transaction_id = jQuery("#gform_tr_id").val();
                jQuery("#tr_result").html("<?php echo __('در حال بررسی', 'GF_TR') ?>");
                jQuery.ajax({
                    url: "<?php echo admin_url('admin-ajax.php') ?>",
                    type: "post",
                    data: {
                        action: "gform_tracking_result",
                        security: "<?php echo wp_create_nonce("gform-tracking"); ?>",
                        transaction_id: transaction_id,
                    },
                    success: function (response) {
                        jQuery("#tr_result").html(response);
                    }
                });
                return false;
            });
        </script>
        <?php
    }


    public function gform_tracking_result()
    {

        global $wpdb;
        check_ajax_referer('gform-tracking', 'security');
        $lead_id = 0;
        $transaction_id = isset($_POST['transaction_id']) ? $_POST['transaction_id'] : '';

        if (ob_get_length()) {
            ob_clean();
        }

        if (!empty($transaction_id) && $transaction_id) {

            $result = $wpdb->get_results($wpdb->prepare("SELECT id, form_id FROM {$wpdb->prefix}rg_lead WHERE transaction_id=%s", $transaction_id), ARRAY_A);

            $count = sizeof($result);

            for ($i = 0; $i < $count; $i++) {

                $lead_id = !empty($result[$i]['id']) ? $result[$i]['id'] : '';
                $form_id = !empty($result[$i]['form_id']) ? $result[$i]['form_id'] : '';

                if (!empty($lead_id) && $form_id == gform_get_meta($lead_id, "hannanstd_form_id")) {
                    break;
                }
            }
        }

        if (!empty($lead_id) && $lead_id) {

            $status = gform_get_meta($lead_id, "hannanstd_entry_status");
            $all_field = gform_get_meta($lead_id, "hannanstd_all_field");


            if ($all_field == 'true') {

                $position = gform_get_meta($lead_id, "hannanstd_status_position");

                $form = RGFormsModel::get_form_meta($form_id);
                $lead = RGFormsModel::get_lead($lead_id);

                if ($position == 'top') {
                    echo GFCommon::replace_variables('{all_fields}', $form, $lead, false, true, false) . wpautop(wptexturize($status));
                } else {
                    echo wpautop(wptexturize($status) . GFCommon::replace_variables('{all_fields}', $form, $lead, false, true, false));
                }

            } else if (!empty($status) && $status) {
                echo wpautop(wptexturize($status));
            } else {
                echo __('مورد جدیدی برای نمایش وجود ندارد .', 'GF_TR');
            }

        } else {
            echo __('کد وارد شده در سیستم وجود ندارد .', 'GF_TR');
        }
        die();

    }


}

new WPFile_GravityForms_Tracking_by_transaction_id();

class GF_WPFile_Tracker extends WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'GF_WPFile_Tracker',
            __('استعلام', 'GF_TR'),
            array('description' => __('ابزارک استعلام', 'GF_TR'),)
            );

    }


    public function form($instance)
    {
        if (isset($instance['title'])) {
            $title = $instance['title'];
$title = __('جهت مشاهده استعلام آنلاین کد سریال گواهینامه خود را در کادر زیر وارد نمایید.*', 'GF_TR');
        } else {
            $title = __('استعلام گواهینامه', 'GF_TR');
           
        }
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>

        <?php
    }

    public function widget($args, $instance)
    {
        $title = apply_filters('widget_title', $instance['title']);
        echo $args['before_widget'];
        if (!empty($title))
            echo $args['before_title'] . $title . $args['after_title'];
        echo do_shortcode('[gform_tracker]');
        echo $args['after_widget'];
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}